/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.figures;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.block.DeputyBlock;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.CutConnectFigure;
import DE.siemens.ad.pdraw.figures.constraints.CuttedConnectionConstraint;
import DE.siemens.ad.pdraw.standard.CCLeftConnector;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Vector;

public class InputCutConnectFigure
extends CutConnectFigure {
    static final long serialVersionUID = -718852490423570380L;
    private int inputCutConnectFigureSerializedDataVersion = 1;
    Vector fOldPointVector = null;

    public InputCutConnectFigure() {
    }

    public InputCutConnectFigure(Point p) {
        int diff = CutConnectFigure.FIGURE_SIZE;
        this.addPoint(p.x, p.y - diff);
        this.addPoint(p.x + diff * 2, p.y - diff);
        this.addPoint(p.x + diff * 3, p.y);
        this.addPoint(p.x + diff * 2, p.y + diff);
        this.addPoint(p.x, p.y + diff);
        this.addPoint(p.x, p.y - diff);
        Point p100 = new Point(p.x, p.y);
        this.fBasePoints[0] = new Point(p100.x, p100.y - FIGURE_SIZE);
        this.fBasePoints[1] = new Point(p100.x + FIGURE_SIZE * 2, p100.y - FIGURE_SIZE);
        this.fBasePoints[2] = new Point(p100.x + FIGURE_SIZE * 3, p100.y);
        this.fBasePoints[3] = new Point(p100.x + FIGURE_SIZE * 2, p100.y + FIGURE_SIZE);
        this.fBasePoints[4] = new Point(p100.x, p100.y + FIGURE_SIZE);
        this.fBasePoints[5] = new Point(p100.x, p100.y - FIGURE_SIZE);
    }

    public Connector connectorAt(int x, int y) {
        return new CCLeftConnector(this);
    }

    public Point connectorStartPoint() {
        Rectangle r = this.parentDisplayBox();
        return new Point(r.x, r.y + r.height / 2);
    }

    public Vector getPointVector() {
        return this.fOldPointVector;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
    }

    public void setDescription(LogoDrawing logoDrawing) {
        CuttedConnectionConstraint ccc = (CuttedConnectionConstraint)this.getConstraint().getContainer();
        InBlockConnector inBlockConnector = ccc.getInBlockConnector();
        OutBlockConnector outBlockConnector = ccc.getOutBlockConnector();
        Block inBlock = inBlockConnector.getOwner();
        Block outBlock = outBlockConnector.getOwner();
        StringBuffer description = new StringBuffer();
        BlockFigure inBlockFigure = logoDrawing.getBlockFigure(inBlock);
        BlockFigure outBlockFigure = logoDrawing.getBlockFigure(outBlock);
        if (inBlockFigure != null && outBlockFigure != null && inBlockFigure.getPageNumber() != outBlockFigure.getPageNumber()) {
            description.append(inBlockFigure.getPageNumber());
            description.append("/");
        }
        if (inBlock.getNumberType() == -2) {
            description.append(((DeputyBlock)inBlock).getParent().getNumberString() + "/");
        } else {
            description.append(inBlock.getNumberString() + "/");
        }
        if (!inBlockConnector.getName().equals("")) {
            description.append(inBlockConnector.getName());
        } else {
            description.append(inBlock.getInConnectorPosition(inBlockConnector) + 1);
        }
        this.fCCTextFigure.setText(description.toString());
    }

    public String getTooltip(LogoDrawing logoDrawing) {
        CuttedConnectionConstraint ccc = (CuttedConnectionConstraint)this.getConstraint().getContainer();
        InBlockConnector inBlockConnector = ccc.getInBlockConnector();
        OutBlockConnector outBlockConnector = ccc.getOutBlockConnector();
        Block inBlock = inBlockConnector.getOwner();
        Block outBlock = outBlockConnector.getOwner();
        StringBuffer description = new StringBuffer("<html>");
        BlockFigure inBlockFigure = logoDrawing.getBlockFigure(inBlock);
        BlockFigure outBlockFigure = logoDrawing.getBlockFigure(outBlock);
        if (inBlockFigure != null && outBlockFigure != null && inBlockFigure.getPageNumber() != outBlockFigure.getPageNumber()) {
            description.append(Language.getString("figure.cuttedConnection.tooltip.page", "Page"));
            description.append(": ");
            description.append(inBlockFigure.getPageNumber());
            description.append("<br>");
        }
        description.append(Language.getString("figure.cuttedConnection.tooltip.block", "Block"));
        description.append(": ");
        description.append(inBlock.getNumberString() + "<br>");
        description.append(Language.getString("figure.cuttedConnection.tooltip.connector", "Connector"));
        description.append(": ");
        if (!inBlockConnector.getName().equals("")) {
            description.append(inBlockConnector.getName());
        } else {
            description.append(inBlock.getInConnectorPosition(inBlockConnector) + 1);
        }
        description.append("</html>");
        return description.toString();
    }

    public void setPointVector(Vector oldVector) {
        this.fOldPointVector = oldVector;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
    }
}

